package com.qboxus.tictic.simpleclasses;

import android.app.Activity;
import android.graphics.Bitmap;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Environment;
import android.widget.Toast;

import androidx.annotation.NonNull;

import com.qboxus.tictic.R;

import java.io.File;
import java.io.FileOutputStream;

public class ImageSaver {

    boolean isSecure = false;
    private String directoryName = "images";
    private String fileName = "image.png";
    private final Activity context;


    public ImageSaver(Activity context, boolean isSecure) {
        this.context = context;
        this.isSecure = isSecure;
    }

    public ImageSaver setFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }


    public ImageSaver setDirectoryName(String directoryName) {
        this.directoryName = directoryName;
        return this;
    }

    public void save(Bitmap bitmapImage) {
        FileOutputStream fileOutputStream = null;
        File outPutFile = createFile();
        try {
            fileOutputStream = new FileOutputStream(outPutFile);
            bitmapImage.compress(Bitmap.CompressFormat.PNG, 100, fileOutputStream);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        MediaScannerConnection.scanFile(context,
                new String[]{outPutFile.getAbsolutePath()},
                null,
                new MediaScannerConnection.OnScanCompletedListener() {
                    public void onScanCompleted(String path, Uri uri) {
                        context.runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                if (!(isSecure))
                                    Toast.makeText(context, context.getString(R.string.image_save_sucessfully), Toast.LENGTH_SHORT).show();
                            }
                        });
                    }
                });
    }

    @NonNull
    private File createFile() {
        File directory;
        if (isSecure) {
            directory = new File(FileUtils.getAppFolder(context) + "/" + directoryName + "/");
        } else {
            directory = new File(Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_DCIM) + "/" + directoryName + "/");
        }
        if (!directory.exists())
            directory.mkdirs();
        return new File(directory, fileName);
    }


}